SET CHARACTER SET utf8mb4;

TRUNCATE TABLE `wa_sent`;

TRUNCATE TABLE `wa_scheduled`;

TRUNCATE TABLE `wa_received`;

ALTER TABLE `devices`
ADD `limit_status` tinyint NOT NULL AFTER `random_max`,
ADD `limit_interval` tinyint NOT NULL AFTER `limit_status`,
ADD `limit_number` int(11) NOT NULL AFTER `limit_interval`;

ALTER TABLE `wa_sent`
ADD `unique` text COLLATE 'utf8mb4_unicode_ci' NOT NULL AFTER `wid`;

ALTER TABLE `wa_scheduled`
ADD `unique` text COLLATE 'utf8mb4_unicode_ci' NOT NULL AFTER `wid`;

ALTER TABLE `wa_received`
ADD `unique` text COLLATE 'utf8mb4_unicode_ci' NOT NULL AFTER `wid`;

ALTER TABLE `sent`
ADD `cid` int(11) NOT NULL AFTER `id`;

ALTER TABLE `wa_sent`
ADD `cid` int(11) NOT NULL AFTER `id`;

ALTER TABLE `users`
ADD `formatting` tinytext COLLATE 'utf8mb4_unicode_ci' NOT NULL AFTER `timezone`;

ALTER TABLE `notifications`
CHANGE `create_date` `create_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP AFTER `text`;

DELETE FROM `settings`
WHERE ((`name` = 'stripe_secret'));

DELETE FROM `settings`
WHERE ((`name` = 'stripe_key'));

INSERT INTO `settings` (`name`, `value`)
VALUES ('wa_server', '');

INSERT INTO `settings` (`name`, `value`)
VALUES ('wa_port', '7001');

INSERT INTO `settings` (`name`, `value`)
VALUES ('partner_commission', '5');

INSERT INTO `settings` (`name`, `value`)
VALUES ('partner_minimum', '50');

UPDATE `devices` SET `limit_status` = 2, `limit_interval` = 1, `limit_number` = 100;

CREATE TABLE `campaigns` (
  `id` int NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `uid` int NOT NULL,
  `did` tinytext NOT NULL,
  `gateway` int NOT NULL,
  `mode` tinyint NOT NULL,
  `status` tinyint NOT NULL,
  `name` tinytext NOT NULL,
  `contacts` int NOT NULL,
  `create_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE `commissions` (
  `id` int NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `pid` int NOT NULL,
  `sid` int NOT NULL,
  `mid` int NOT NULL,
  `did` tinytext NOT NULL,
  `original_amount` float NOT NULL,
  `commission_amount` float NOT NULL,
  `currency` tinytext NOT NULL,
  `create_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE `wa_campaigns` (
  `id` int NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `uid` int NOT NULL,
  `wid` tinytext NOT NULL,
  `type` tinytext NOT NULL,
  `status` int NOT NULL,
  `name` tinytext NOT NULL,
  `contacts` int NOT NULL,
  `create_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE `wa_groups` (
  `id` int NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `uid` int NOT NULL,
  `wid` tinytext NOT NULL,
  `gid` tinytext NOT NULL,
  `name` tinytext NOT NULL,
  `create_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
);